<?php

namespace App\Http\Controllers;

use App\Models\AgeCategory;
use Illuminate\Http\Request;

class AgeCategoryController extends Controller
{
    // Show all age categories
    public function index()
    {
        $categories = AgeCategory::all();
        return view('age_categories.index', compact('categories'));
    }

    // Show create form
    public function create()
    {
        return view('age_categories.create');
    }

    // Store new category
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'min_age' => 'nullable|date',
            'max_age' => 'nullable|date|after_or_equal:min_age',
        ]);

        // Ensure min_age and max_age are null if not provided
        $minAge = $validated['min_age'] ?? null;
        $maxAge = $validated['max_age'] ?? null;

        AgeCategory::create([
            'name' => $validated['name'],
            'min_age' => $minAge,
            'max_age' => $maxAge,
        ]);

        return redirect()->route('age_categories.index')->with('success', 'Age category created successfully.');
    }

    // Show edit form
    public function edit($id)
    {
        $category = AgeCategory::findOrFail($id);
        return view('age_categories.edit', compact('category'));
    }

    // Update category
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'min_age' => 'nullable|date',
            'max_age' => 'nullable|date|after_or_equal:min_age',
        ]);

        $category = AgeCategory::findOrFail($id);

        $category->update([
            'name' => $validated['name'],
            'min_age' => $validated['min_age'] ?? null,
            'max_age' => $validated['max_age'] ?? null,
        ]);

        return redirect()->route('age_categories.index')->with('success', 'Age category updated successfully.');
    }

    // Delete category
    public function destroy($id)
    {
        $category = AgeCategory::findOrFail($id);

        // Delete all athletes in this age category
        $category->athletes()->delete();

        // Now delete the age category itself
        $category->delete();

        return redirect()->route('age_categories.index')->with('success', 'Age category and related athletes deleted successfully.');
    }
}
