<?php

namespace App\Http\Controllers;

use App\Models\AssignApparatus;
use App\Models\Competition;
use App\Models\Apparatus;
use App\Models\User;
use Illuminate\Http\Request;
use App\Imports\AssignApparatusImport;
use Maatwebsite\Excel\Facades\Excel;
class AssignApparatusController extends Controller
{
    /**
     * Display the assignment list and the form.
     */
    public function index()
    {
        $assignments = AssignApparatus::with(['competition', 'judge', 'apparatus'])->latest()->get();
        $competitions = Competition::all();
        $users = User::all();
        $apparatuses = Apparatus::all();

        return view('assign_apparatus.index', compact('assignments', 'competitions', 'users', 'apparatuses'));
    }

    /**
     * Optional: Show create form (not used if inline on index).
     */
    public function create()
    {
        $competitions = Competition::all();
        $users = User::where('is_judge',true)->get();
        $apparatuses = Apparatus::all();

        return view('assign_apparatus.create', compact('competitions', 'users', 'apparatuses'));
    }

    /**
     * Store a new judge-apparatus assignment.
     */
    public function store(Request $request)
    {
        $request->validate([
            'competition_id' => 'required|exists:competitions,id',
            'user_id' => 'required|exists:users,id',
            'apparatus_id' => 'required|exists:apparatus,id',
        ]);

        AssignApparatus::create($request->only(['competition_id', 'user_id', 'apparatus_id']));

        return redirect()->route('assignapparatus.index')->with('success', 'Assignment added successfully.');
    }

    /**
     * Optional: Show edit form for a specific assignment.
     */
    public function edit($id)
    {
        $assignment = AssignApparatus::findOrFail($id);
        $competitions = Competition::all();
        $users = User::where('is_judge',true)->get();
        $apparatuses = Apparatus::all();

        return view('assign_apparatus.edit', compact('assignment', 'competitions', 'users', 'apparatuses'));
    }

    /**
     * Update an existing assignment.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'competition_id' => 'required|exists:competitions,id',
            'user_id' => 'required|exists:users,id',
            'apparatus_id' => 'required|exists:apparatus,id',
        ]);

        $assignment = AssignApparatus::findOrFail($id);
        $assignment->update($request->only(['competition_id', 'user_id', 'apparatus_id']));

        return redirect()->route('assignapparatus.index')->with('success', 'Assignment updated successfully.');
    }

    /**
     * Delete an assignment.
     */
    public function destroy($id)
    {
        $assignment = AssignApparatus::findOrFail($id);
        $assignment->delete();

        return redirect()->route('assignapparatus.index')->with('success', 'Assignment deleted.');
    }

    public function import(Request $request)
{
    $request->validate([
        'file' => 'required|file|mimes:xlsx,csv,txt',
    ]);

    Excel::import(new AssignApparatusImport, $request->file('file'));

    return back()->with('success', 'AssignApparatus data imported successfully!');
}

}
