<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    protected $redirectTo = '/index';

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
    }

    /**
     * Called after the user is authenticated.
     */
    protected function authenticated(Request $request, $user)
    {
        // Only gate club users; others proceed.
        if ($user->is_club) {
            $club = $user->club;

            // 1) Must have a linked club
            if (!$club) {
                Auth::logout();
                return back()
                    ->withInput($request->only('email'))
                    ->withErrors(['email' => 'This club account is not linked to any club record.']);
            }

            // 2) Club must be active by dates
            if (!$club->is_active) {
                Auth::logout();
                return back()
                    ->withInput($request->only('email'))
                    ->withErrors(['email' => 'Club access is expired or not active. Contact the organizer.']);
            }
        }

        // All good → proceed to intended page
        return redirect()->intended($this->redirectPath());
    }
}
