<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    // Show all categories
    public function index()
    {
        $categories = Category::all();
        return view('categories.index', compact('categories'));
    }

    // Show create form
    public function create()
    {
        return view('categories.create');
    }

    // Store new category
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'gender' => 'required|in:male,female',
            'description' => 'nullable|string',
        ]);

        Category::create($request->only(['name', 'gender', 'description']));

        return redirect()->route('categories.index')->with('success', 'Category created successfully.');
    }

    // Show edit form
    public function edit($id)
    {
        $category = Category::findOrFail($id);
        return view('categories.edit', compact('category'));
    }

    // Update category
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'gender' => 'required|in:male,female',
            'description' => 'nullable|string',
        ]);

        $category = Category::findOrFail($id);
        $category->update($request->only(['name', 'gender', 'description']));

        return redirect()->route('categories.index')->with('success', 'Category updated successfully.');
    }

    // Delete category
   public function destroy($id)
{
    $category = Category::findOrFail($id);

    // Delete related apparatus records first
    $category->apparatus()->delete();

    $category->delete();

    return redirect()->route('categories.index')->with('success', 'Category and its apparatus deleted successfully.');
}
}
