<?php
namespace App\Http\Controllers;

use App\Models\Group;
use App\Models\Competition;
use Illuminate\Http\Request;
use App\Imports\GroupImport;
use Maatwebsite\Excel\Facades\Excel;
class GroupController extends Controller
{
    public function index()
    {
        $groups = Group::with('competition')->latest()->get();
        return view('groups.index', compact('groups'));
    }

    public function create()
    {
        $competitions = Competition::all();
        return view('groups.create', compact('competitions'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'competition_id' => 'nullable|exists:competitions,id',
            'name' => 'required|string|max:10',
        ]);

        Group::create($request->only(['competition_id', 'name']));

        return redirect()->route('groups.index')->with('success', 'Group created successfully.');
    }

    public function edit($id)
    {
        $group = Group::findOrFail($id);
        $competitions = Competition::all();
        return view('groups.edit', compact('group', 'competitions'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'competition_id' => 'nullable|exists:competitions,id',
            'name' => 'required|string|max:10',
        ]);

        $group = Group::findOrFail($id);
        $group->update($request->only(['competition_id', 'name']));

        return redirect()->route('groups.index')->with('success', 'Group updated successfully.');
    }

    public function destroy($id)
    {
        $group = Group::findOrFail($id);
        $group->delete();

        return redirect()->route('groups.index')->with('success', 'Group deleted successfully.');
    }

    public function importExcel(Request $request)
{
    $request->validate([
        'excel' => 'required|file|mimes:xlsx,xls'
    ]);

    $import = new GroupImport;

    Excel::import($import, $request->file('excel'));

    return back()
        ->with('success', "Imported {$import->insertCount} groups successfully.")
        ->with('invalidRows', $import->invalid);
}
}
