<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Athlete;
use App\Models\Apparatus;
use App\Models\User;
use App\Models\Competition;
use App\Models\Score;
use App\Models\RoundRotation;
use Illuminate\Support\Facades\DB;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function index()
    {
        $user = Auth::user();

        if ($user->is_judge) {
            return redirect()->route('judge.competitions');
        }
        if ($user->is_club) {
            return redirect()->route('owner.club.index');
        }

        $totalAthletes = Athlete::count();
        $totalApparatus = Apparatus::count();
        $totalJudges = User::where('is_judge', true)->count();
        $totalCompetitions = Competition::count();
        $totalScores = Score::count();
        $completedRounds = RoundRotation::where('status', 'completed')->count();
        $totalRounds = RoundRotation::distinct('round_number')->count();

        $topAthletes = Score::select('athlete_id', DB::raw('SUM(final_score) as total'))->groupBy('athlete_id')->with('athlete')->orderByDesc('total')->take(5)->get();

        // NEW: Competition + Athletes + Total Scores
        $competitionScores = Competition::with(['scores.athlete'])
            ->get()
            ->map(function ($competition) {
                $athleteScores = $competition->scores
                    ->groupBy('athlete_id')
                    ->map(function ($scores) {
                        $athlete = $scores->first()->athlete;
                        $total = $scores->sum('final_score');
                        return [
                            'athlete_name' => $athlete->first_name . ' ' . $athlete->last_name,
                            'total' => round($total, 2),
                        ];
                    })
                    ->values();

                return [
                    'name' => $competition->name,
                    'athletes' => $athleteScores,
                ];
            });

        return view('home', compact('totalAthletes', 'totalApparatus', 'totalJudges', 'totalCompetitions', 'totalScores', 'completedRounds', 'totalRounds', 'topAthletes', 'competitionScores'));
    }
}
