<?php

namespace App\Http\Controllers;

use App\Models\Level;
use Illuminate\Http\Request;

class LevelController extends Controller
{
    // Show all levels
    public function index()
    {
        $levels = Level::all();
        return view('levels.index', compact('levels'));
    }

    // Show create form
    public function create()
    {
        return view('levels.create');
    }

    // Store new level
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:50',
            'description' => 'nullable|string',
        ]);

        Level::create($request->only(['name', 'description']));

        return redirect()->route('levels.index')->with('success', 'Level created successfully.');
    }

    // Show edit form
    public function edit($id)
    {
        $level = Level::findOrFail($id);
        return view('levels.edit', compact('level'));
    }

    // Update level
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:50',
            'description' => 'nullable|string',
        ]);

        $level = Level::findOrFail($id);
        $level->update($request->only(['name', 'description']));

        return redirect()->route('levels.index')->with('success', 'Level updated successfully.');
    }

    // Delete level
    public function destroy($id)
    {
        $level = Level::findOrFail($id);
        $level->delete();

        return redirect()->route('levels.index')->with('success', 'Level deleted successfully.');
    }
}
