<?php

namespace App\Imports;

use App\Models\Group;
use App\Models\Competition;
use Maatwebsite\Excel\Row;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class GroupImport implements OnEachRow, WithHeadingRow
{
    public $invalid = [];
    public $insertCount = 0;

    public function onRow(Row $row)
    {
        $data = $row->toArray();

        // Skip empty rows
        if (!array_filter($data)) {
            return;
        }

        $groupName       = trim($data['group_name'] ?? '');
        $competitionName = trim($data['competition_name'] ?? '');

        if ($groupName === '') {
            $this->invalid[] = [
                'row' => $row->getIndex(),
                'group_name' => $groupName,
                'competition_name' => $competitionName,
                'error' => 'Group name is missing'
            ];
            return;
        }

        // Lookup competition by name (optional)
        $competition = Competition::where('name', $competitionName)->first();

        if ($competitionName !== '' && !$competition) {
            $this->invalid[] = [
                'row' => $row->getIndex(),
                'group_name' => $groupName,
                'competition_name' => $competitionName,
                'error' => 'Competition not found'
            ];
            return;
        }

        Group::create([
            'name' => $groupName,
            'competition_id' => $competition?->id
        ]);

        $this->insertCount++;
    }
}
