<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AgeCategory extends Model
{
    protected $fillable = [
        'name',
        'min_age',
        'max_age',
    ];

    /**
     * Get the athletes assigned to this age category.
     */
    public function athletes(): HasMany
    {
        return $this->hasMany(Athlete::class);
    }
}
