<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Apparatus extends Model
{
    protected $table = 'apparatus';
    protected $fillable = ['name', 'category_id', 'slug'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public static function idVault1(): ?int
    {
        return static::where('slug', 'vault')->value('id') ?? static::where('name', 'Vault (V)')->value('id');
    }
    public static function idVault2(): ?int
    {
        return static::where('slug', 'vault-2')->value('id') ?? static::where('name', 'Vault 2 (V2)')->value('id');
    }
}
