<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignApparatus extends Model
{
    use HasFactory;

    protected $table = 'competition_judge';

    protected $fillable = [
        'competition_id',
        'user_id',
        'apparatus_id',
    ];

    public function competition() {
        return $this->belongsTo(Competition::class);
    }

    public function judge() {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function apparatus() {
        return $this->belongsTo(Apparatus::class);
    }
}
