<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Athlete extends Model
{
    use HasFactory;

    protected $fillable = ['first_name', 'last_name','photo_url',  'gender', 'dob', 'club_id', 'country_id', 'age_category_id', 'level_id', 'category_id', 'type'];
    protected $casts = [
        'dob' => 'datetime',
    ];
    public function club()
    {
        return $this->belongsTo(Club::class);
    }
    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    public function ageCategory()
    {
        return $this->belongsTo(AgeCategory::class);
    }
    public function level()
    {
        return $this->belongsTo(Level::class);
    }
    public function category()
    {
        return $this->belongsTo(Category::class);
    }
    public function scores()
    {
        return $this->hasMany(Score::class);
    }
    public function competitionAthletes()
{
    return $this->hasMany(CompetitionAthlete::class);
}

}
