<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Club extends Model
{
    protected $fillable = ['name', 'country_id', 'start_date', 'end_date', 'user_id'];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    public function getIsActiveAttribute(): bool
    {
        $now = now();

        // if either missing, treat as inactive
        if (!$this->start_date || !$this->end_date) {
            return false;
        }

        // active only within the full datetime window
        return $this->start_date->lte($now) && $this->end_date->gte($now);
    }
    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function athletes()
    {
        return $this->hasMany(\App\Models\Athlete::class, 'club_id');
    }
}
