<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompetitionAthlete extends Model
{
    use HasFactory;

    protected $table = 'competition_athlete'; // explicitly define if not plural

    protected $fillable = [
        'competition_id',
        'athlete_id',
        'group_id',
    ];

    public function competition()
    {
        return $this->belongsTo(Competition::class);
    }

    public function athlete()
    {
        return $this->belongsTo(Athlete::class);
    }

    public function group()
    {
        return $this->belongsTo(Group::class);
    }
}
