<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RoundRotation extends Model
{
    protected $fillable = ['competition_id', 'round_number', 'group_id', 'apparatus_id', 'is_vault2'];
    protected $casts = [
        'is_vault2' => 'bool',
    ];
    public function competition()
    {
        return $this->belongsTo(Competition::class);
    }

    public function group()
    {
        return $this->belongsTo(Group::class);
    }

    public function apparatus()
    {
        return $this->belongsTo(Apparatus::class);
    }
}
