<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateUsersTableAddFirstAndLastName extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // Rename the old column (if necessary) and add new columns
            $table->renameColumn('name', 'first_name'); // Rename column (if you had 'name')
            $table->string('last_name')->after('first_name'); // Add the 'last_name' column
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            // Revert the changes if the migration is rolled back
            $table->renameColumn('first_name', 'name'); // Rename back to 'name'
            $table->dropColumn('last_name'); // Drop the 'last_name' column
        });
    }
}
