<?php

// database/migrations/2025_10_11_000001_add_vault2_flags_to_competitions.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::table('competitions', function (Blueprint $t) {
      $t->boolean('enable_vault2')->default(false)->index();
      $t->enum('vault2_status', ['pending','ready','open','complete'])->default('pending')->index();
      // optional: timestamp when V2 completed
      $t->timestamp('vault2_completed_at')->nullable();
    });
  }
  public function down(): void {
    Schema::table('competitions', function (Blueprint $t) {
      $t->dropColumn(['enable_vault2','vault2_status','vault2_completed_at']);
    });
  }
};
