<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('round_rotations', function (Blueprint $table) {
            $table->boolean('is_vault2')->default(false)->index()->after('apparatus_id');
        });
    }

    public function down(): void
    {
        Schema::table('round_rotations', function (Blueprint $table) {
            // Drop the index first (name is the conventional one)
            $table->dropIndex('round_rotations_is_vault2_index');
            $table->dropColumn('is_vault2');
        });
    }
};
