<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  public function up()
{
    Schema::table('clubs', function (Blueprint $table) {
        $table->date('start_date')->nullable()->after('country_id');
        $table->date('end_date')->nullable()->after('start_date');
        // Optional (MySQL 8+):
        // $table->check('(end_date IS NULL OR start_date IS NULL OR end_date >= start_date)');
    });
}

public function down()
{
    Schema::table('clubs', function (Blueprint $table) {
        $table->dropColumn(['start_date', 'end_date']);
    });
}

};
