<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('certificate_templates', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('competition_id');
            $table->string('title')->default('Certificate of Participation');
            $table->string('background_path'); // storage path to fixed-size image
            $table->json('custom_fields')->nullable(); // e.g., {"subtitle":"…","footer":"…"}
            $table->json('style')->nullable(); // positions/sizes/colors per field (optional)
            $table->timestamps();
            $table->unique(['competition_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('certificate_templates');
    }
};
