<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('competitions', function (Blueprint $table) {
            $table->boolean('is_team_competition')->default(false);
            $table->unsignedBigInteger('club_a_id')->nullable();
            $table->unsignedBigInteger('club_b_id')->nullable();

        });
    }

    public function down(): void {
        Schema::table('competitions', function (Blueprint $table) {
            $table->dropForeign(['club_a_id','club_b_id']);
            $table->dropColumn(['is_team_competition','club_a_id','club_b_id']);
        });
    }
};
