<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('groups', function (Blueprint $table) {
            // Increase the length of the name column to 100 characters
            $table->string('name', 100)->change();
        });
    }

    public function down(): void
    {
        Schema::table('groups', function (Blueprint $table) {
            // Rollback: revert to previous length (e.g., 50)
            $table->string('name', 50)->change();
        });
    }
};
