<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ApparatusSlugBackfillSeeder extends Seeder
{
    public function run(): void
    {
        // Known display names → canonical slugs
        $map = [
            'Vault (V)'           => 'vault',
            'Vault 2 (V2)'        => 'vault-2',
            'Uneven Bars (UB)'    => 'bars',
            'Balance Beam (BB)'   => 'beam',
            'Floor Exercise (FX)' => 'floor',
        ];

        DB::transaction(function () use ($map) {
            // 1) Apply explicit map first
            foreach ($map as $name => $slug) {
                DB::table('apparatus')
                    ->where('name', $name)
                    ->whereNull('slug') // don’t overwrite if already set
                    ->update(['slug' => $slug]);
            }

            // 2) For any remaining rows without slug, derive from name safely
            $rows = DB::table('apparatus')->whereNull('slug')->get(['id','name']);

            foreach ($rows as $r) {
                // e.g., "Something (XX)" → "something"
                $base = preg_replace('/\s*\([^)]*\)\s*/', '', (string)$r->name);
                $slug = Str::slug($base ?: 'apparatus-'.$r->id);

                // Ensure uniqueness: if taken, append id
                $exists = DB::table('apparatus')->where('slug', $slug)->exists();
                if ($exists) {
                    $slug = $slug.'-'.$r->id;
                }

                DB::table('apparatus')->where('id', $r->id)->update(['slug' => $slug]);
            }
        });
    }
}
