@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4>Edit Age Category</h4>
            <a href="{{ route('age_categories.index') }}" class="btn btn-secondary btn-sm">← Back to List</a>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form method="POST" action="{{ route('age_categories.update', $category->id) }}">
                @csrf

                <div class="form-group">
                    <label for="name">Category Name <span class="text-danger">*</span></label>
                    <input type="text" id="name" name="name" class="form-control"
                           value="{{ old('name', $category->name) }}" required>
                </div>

                <div class="form-group">
                    <label for="min_age">Minimum Age</label>
                    <input type="date" id="min_age" name="min_age" class="form-control"
                           value="{{ old('min_age', $category->min_age) }}">
                </div>

                <div class="form-group">
                    <label for="max_age">Maximum Age</label>
                    <input type="date" id="max_age" name="max_age" class="form-control"
                           value="{{ old('max_age', $category->max_age) }}">
                </div>

                <button type="submit" class="btn btn-primary">Update Category</button>
            </form>
        </div>
    </div>
</div>
@endsection
