@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Edit Apparatus</h4>
    </div>
    <div class="card-body">
        @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        <form action="{{ route('apparatus.update', $apparatus->id) }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="name">Apparatus Name</label>
                <input type="text" name="name" value="{{ $apparatus->name }}" class="form-control" required>
            </div>

            <div class="form-group">
                <label for="category_id">Select Category</label>
                <select name="category_id" class="form-control">
                    <option value="">-- None --</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ $apparatus->category_id == $category->id ? 'selected' : '' }}>
                            {{ $category->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <button type="submit" class="btn btn-primary">Update</button>
            <a href="{{ route('apparatus.index') }}" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
</div>
@endsection
