@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Assign Judge to Apparatus</h4>
    </div>

    <div class="card-body">
        {{-- Display validation errors --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <strong>There were some problems with your input:</strong>
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('assignapparatus.store') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-2">
                    <label>Competition</label>
                    <select name="competition_id" class="form-control" required>
                        <option value="">Select Competition</option>
                        @foreach($competitions as $competition)
                            <option value="{{ $competition->id }}">{{ $competition->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Judge (User)</label>
                    <select name="user_id" class="form-control" required>
                        <option value="">Select Judge</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}">{{ $user->first_name.' '. $user->last_name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Apparatus</label>
                    <select name="apparatus_id" class="form-control" required>
                        <option value="">Select Apparatus</option>
                        @foreach($apparatuses as $apparatus)
                            <option value="{{ $apparatus->id }}">{{ $apparatus->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="mt-2">
                <button class="btn btn-primary">Assign</button>
                <a href="{{ route('assignapparatus.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
