@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Edit Assignment</h4>
    </div>

    <div class="card-body">
        {{-- Display validation errors --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <strong>There were some problems with your input:</strong>
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('assignapparatus.update', $assignment->id) }}" method="POST">
            @csrf
            @method('POST') {{-- Since route is post not PUT --}}
            <div class="row">
                <div class="col-md-6 mb-2">
                    <label>Competition</label>
                    <select name="competition_id" class="form-control" required>
                        @foreach($competitions as $competition)
                            <option value="{{ $competition->id }}" {{ $assignment->competition_id == $competition->id ? 'selected' : '' }}>
                                {{ $competition->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Judge (User)</label>
                    <select name="user_id" class="form-control" required>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ $assignment->user_id == $user->id ? 'selected' : '' }}>
                                {{ $user->first_name." ". $user->last_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Apparatus</label>
                    <select name="apparatus_id" class="form-control" required>
                        @foreach($apparatuses as $apparatus)
                            <option value="{{ $apparatus->id }}" {{ $assignment->apparatus_id == $apparatus->id ? 'selected' : '' }}>
                                {{ $apparatus->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="mt-2">
                <button class="btn btn-primary">Update</button>
                <a href="{{ route('assignapparatus.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
