@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Edit Athlete</h4>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form action="{{ route('athletes.update', $athlete->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT') <!-- important for update routes -->

                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label>First Name</label>
                        <input type="text" name="first_name" class="form-control"
                            value="{{ old('first_name', $athlete->first_name) }}" required>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Last Name</label>
                        <input type="text" name="last_name" class="form-control"
                            value="{{ old('last_name', $athlete->last_name) }}">
                    </div>

                    <div class="col-md-6 mb-2 d-flex align-items-center">
                        <div class="w-75">
                            <label for="photo_url">Upload New Photo</label>
                            <input type="file" name="photo_url" class="form-control">
                            <small class="text-muted">Leave empty to keep current photo.</small>
                        </div>

                        @if ($athlete->photo_url)
                            <div class="ml-3">
                                <img src="{{ asset($athlete->photo_url) }}" alt="Athlete Photo" class="rounded border"
                                    width="80" height="80" style="object-fit: cover;">
                            </div>
                        @endif
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Gender</label>
                        <select name="gender" class="form-control" required>
                            <option value="">Select Gender</option>
                            <option value="male" {{ old('gender', $athlete->gender) == 'male' ? 'selected' : '' }}>Male
                            </option>
                            <option value="female" {{ old('gender', $athlete->gender) == 'female' ? 'selected' : '' }}>
                                Female</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Date of Birth</label>
                        <input type="date" name="dob" class="form-control"
                            value="{{ old('dob', optional($athlete->dob)->format('Y-m-d')) }}">
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Club</label>
                        <select name="club_id" class="form-control">
                            <option value="">Select Club</option>
                            @foreach ($clubs as $club)
                                <option value="{{ $club->id }}"
                                    {{ old('club_id', $athlete->club_id) == $club->id ? 'selected' : '' }}>
                                    {{ $club->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Type</label>
                        <select name="type" class="form-control">
                            <option value="">Select Type</option>
                            <option value="Club" {{ old('type', $athlete->type) == 'Club' ? 'selected' : '' }}>Club
                            </option>
                            <option value="Academy" {{ old('type', $athlete->type) == 'Academy' ? 'selected' : '' }}>
                                Academy</option>
                            <option value="FIG" {{ old('type', $athlete->type) == 'FIG' ? 'selected' : '' }}>FIG
                            </option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-2">
                        <label>Country</label>
                        <select name="country_id" class="form-control">
                            <option value="">Select Country</option>
                            @foreach ($countries as $country)
                                <option value="{{ $country->id }}"
                                    {{ old('country_id', $athlete->country_id) == $country->id ? 'selected' : '' }}>
                                    {{ $country->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Age Category</label>
                        <select name="age_category_id" class="form-control">
                            <option value="">Select Age Category</option>
                            @foreach ($ageCategories as $cat)
                                <option value="{{ $cat->id }}"
                                    {{ old('age_category_id', $athlete->age_category_id) == $cat->id ? 'selected' : '' }}>
                                    {{ $cat->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Level</label>
                        <select name="level_id" class="form-control">
                            <option value="">Select Level</option>
                            @foreach ($levels as $level)
                                <option value="{{ $level->id }}"
                                    {{ old('level_id', $athlete->level_id) == $level->id ? 'selected' : '' }}>
                                    {{ $level->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Category</label>
                        <select name="category_id" class="form-control">
                            <option value="">Select Category</option>
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}"
                                    {{ old('category_id', $athlete->category_id) == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="mt-2">
                    <button class="btn btn-primary">Update</button>
                    <a href="{{ route('athletes.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>

        </div>
    </div>
@endsection
