@extends('layouts.app')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/vendors.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
@endsection

@section('content')
    <section id="athlete-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Athletes</h4>
                        <div>
                            <a href="{{ route('athletes.create') }}" class="btn btn-primary mr-2">
                                <i class="bx bx-plus"></i> Add Athlete
                            </a>
                            <button class="btn btn-outline-success" data-toggle="modal" data-target="#importAthleteModal">
                                <i class="bx bx-upload"></i> Import Athletes
                            </button>
                        </div>
                    </div>
                    @if (session('import_errors') && count(session('import_errors')) > 0)
                        <div class="alert alert-warning mt-3">
                            <h5 class="alert-heading">
                                Some rows were not imported ({{ count(session('import_errors')) }} rows)
                            </h5>
                            <p class="mb-2">Please review the errors below, fix the file, and try again only for those
                                athletes if needed.</p>

                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Row</th>
                                            <th>Athlete</th>
                                            <th>Errors</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach (session('import_errors') as $errorRow)
                                            <tr>
                                                <td>{{ $errorRow['row'] }}</td>
                                                <td>
                                                    {{ $errorRow['data']['first_name'] ?? '' }}
                                                    {{ $errorRow['data']['last_name'] ?? '' }}
                                                </td>
                                                <td>
                                                    <ul class="mb-0">
                                                        @foreach ($errorRow['errors'] as $msg)
                                                            <li>{{ $msg }}</li>
                                                        @endforeach
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif

                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table zero-configuration">
                                <thead>
                                    <tr>
                                        <th>*</th>
                                        <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Image</th>
                                        <th>Gender</th>
                                        <th>DOB</th>
                                        <th>Club</th>
                                        <th>Type</th>
                                        <th>Country</th>
                                        <th>Age Category</th>
                                        <th>Level</th>
                                        <th>Category</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($athletes as $athlete)
                                        <tr>
                                            <td>{{ $athlete->id }}</td>
                                            <td>{{ $athlete->first_name }}</td>
                                            <td>{{ $athlete->last_name ?? '-' }}</td>
                                            <td><img src="{{ asset($athlete->photo_url) }}" alt="Athlete Photo"
                                                    class="rounded border" width="80" height="80"
                                                    style="object-fit: cover;"></td>
                                            <td>{{ ucfirst($athlete->gender) }}</td>
                                            <td>{{ $athlete->dob ? $athlete->dob->format('Y-m-d') : '-' }}</td>
                                            <td>{{ $athlete->club?->name ?? '-' }}</td>
                                            <td>{{ $athlete->type ?? '-' }}</td>
                                            <td>{{ $athlete->country?->name ?? '-' }}</td>
                                            <td>{{ $athlete->ageCategory?->name ?? '-' }}</td>
                                            <td>{{ $athlete->level?->name ?? '-' }}</td>
                                            <td>{{ $athlete->category?->name ?? '-' }}</td>
                                            <td>
                                                <a href="{{ route('athletes.edit', $athlete->id) }}"
                                                    class="btn btn-sm btn-warning">Edit</a>
                                                <button type="button" class="btn btn-sm btn-danger btn-delete"
                                                    data-url="{{ route('athletes.destroy', $athlete->id) }}">
                                                    Delete
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>

                                <tfoot>
                                    <tr>
                                        <th>*</th>
                                        <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Image</th>
                                        <th>Gender</th>
                                        <th>DOB</th>
                                        <th>Club</th>
                                        <th>Country</th>
                                        <th>Age Category</th>
                                        <th>Level</th>
                                        <th>Category</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Import Athletes Modal -->
        <div class="modal fade" id="importAthleteModal" tabindex="-1" role="dialog"
            aria-labelledby="importAthleteModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <form action="{{ route('athletes.import') }}" method="POST" enctype="multipart/form-data"
                    class="modal-content">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" id="importAthleteModalLabel">Import Athletes</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <a href="{{ asset('Athlete.xlsx') }}" class="btn btn-sm btn-info">Download Sample File</a>
                       

                        <div class="form-group">
                            <label for="importFile">Select CSV or Excel file</label>
                            <input type="file" name="file" id="importFile" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success"><i class="bx bx-upload"></i> Import</button>
                    </div>
                </form>
            </div>
        </div>
    @endsection

    @section('js')
        <!-- BEGIN: Page Vendor JS-->
        <script src="{{ asset('app-assets/vendors/js/ui/jquery.sticky.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
        <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
        <!-- END: Page Vendor JS-->



        <!-- BEGIN: Page JS-->
        <script src="{{ asset('app-assets/js/scripts/datatables/datatable.js') }}"></script>
        <!-- END: Page JS-->
    @endsection
