@extends('auth.master')
@section('page-title', 'Register')
@section('auth-content')
    <section class="row flexbox-container">
        <div class="col-xl-8 col-10">
            <div class="card bg-authentication mb-0">
                <div class="row m-0">
                    <!-- Register Section Left -->
                    <div class="col-md-6 col-12 px-0">
                        <div class="card disable-rounded-right mb-0 p-2 h-100 d-flex justify-content-center">
                            <div class="card-header pb-1">
                                <div class="card-title">
                                    <h4 class="text-center mb-2">Sign Up</h4>
                                </div>
                            </div>
                            <div class="text-center">
                                <p> <small> Please enter your details to sign up and be part of our great community</small>
                                </p>
                            </div>
                            <div class="card-body">
                                @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
                                <!-- Registration Form -->
                                <form method="POST" action="{{ route('register') }}">
                                    @csrf

                                    <div class="form-group mb-50">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                                            id="name" name="name" value="{{ old('name') }}"
                                            placeholder="Name" required>
                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="form-group mb-50">
                                        <label for="email" class="text-bold-600">Email Address</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                                            id="email" name="email" value="{{ old('email') }}"
                                            placeholder="Email address" required>
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="password" class="text-bold-600">Password</label>
                                        <input type="password" class="form-control @error('password') is-invalid @enderror"
                                            id="password" name="password" placeholder="Password" required>
                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="password_confirmation" class="text-bold-600">Confirm Password</label>
                                        <input type="password" class="form-control" id="password_confirmation"
                                            name="password_confirmation" placeholder="Confirm Password" required>
                                    </div>

                                    <button type="submit" class="btn btn-primary glow position-relative w-100">SIGN UP<i
                                            id="icon-arrow" class="bx bx-right-arrow-alt"></i></button>
                                </form>

                                <hr>
                                <div class="text-center">
                                    <small class="mr-25">Already have an account?</small>
                                    <a href="{{ route('login') }}"><small>Sign in</small></a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Image Section Right -->
                    <div class="col-md-6 d-md-block d-none text-center align-self-center p-3">
                        <img class="img-fluid" src="/app-assets/images/pages/register.png" alt="branding logo">
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
