@php
  $style = (array) data_get($template, 'style', []);
  $subtitle = data_get($template, 'custom_fields.subtitle');
  $footer = data_get($template, 'custom_fields.footer');
@endphp

@if($template && $template->background_path)
  <img src="{{ asset($template->background_path) }}" class="img-fluid w-100" alt="bg">
@else
  <div class="p-5 text-center text-muted">No template background uploaded yet.</div>
@endif

<div style="position:absolute; top:15%; left:0; right:0; text-align:center;">
  <div style="font-size:{{ $style['title_font'] ?? 28 }}px; font-weight:600;">
    {{ $template->title ?? 'Certificate' }}
  </div>
  @if($subtitle)
    <div style="font-size:{{ $style['subtitle_font'] ?? 18 }}px;">{{ $subtitle }}</div>
  @endif
</div>

@if($footer)
  <div style="position:absolute; bottom:6%; left:0; right:0; text-align:center; font-size:14px;">
    {{ $footer }}
  </div>
@endif
