@extends('layouts.app')
@section('content')
    <div class="container py-4">
        <h3 class="mb-4">Certificates — {{ $competition->title ?? 'Competition #' . $competition->id }}</h3>


        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif


        <div class="card mb-4">
            <div class="card-header">Template</div>
            <div class="card-body">
                <form action="{{ route('certificates.template.store', $competition) }}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control"
                                value="{{ old('title', optional($template)->title) }}" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label>Background image (fixed size PNG/JPG)</label>
                            <input type="file" name="background" class="form-control-file">
                            @if ($template && $template->background_path)
                                <small class="text-muted d-block mt-2">Current:
                                    <code>{{ $template->background_path }}</code></small>
                            @endif
                        </div>
                    </div>

@php
  $cf = (array) data_get($template, 'custom_fields', []);
  $style = (array) data_get($template, 'style', []);
@endphp
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label>Subtitle</label>
                           <input type="text" name="custom_fields[subtitle]" class="form-control"
       value="{{ old('custom_fields.subtitle', $cf['subtitle'] ?? '') }}">
                        </div>
                        <div class="form-group col-md-4">
                            <label>Footer note</label>
               <input type="text" name="custom_fields[footer]" class="form-control"
       value="{{ old('custom_fields.footer', $cf['footer'] ?? '') }}">
                        </div>
                    </div>


                    {{-- Optional: simple positioning controls --}}
                    <div class="form-row">
                        <div class="form-group col-md-3">
                            <label>Name font size (px)</label>
                 <input type="number" name="style[name_font]" class="form-control"
       value="{{ old('style.name_font', $style['name_font'] ?? 42) }}">

                        </div>
                        <div class="form-group col-md-3">
                            <label>Title font size (px)</label>
                           <input type="number" name="style[title_font]" class="form-control"
       value="{{ old('style.title_font', $style['title_font'] ?? 28) }}">
                        </div>
                        <div class="form-group col-md-3">
                            <label>Subtitle font size (px)</label>
                         <input type="number" name="style[subtitle_font]" class="form-control"
       value="{{ old('style.subtitle_font', $style['subtitle_font'] ?? 18) }}">
                        </div>
                    </div>


                    <button class="btn btn-primary">Save Template</button>
                    <a class="btn btn-outline-secondary" href="{{ route('certificates.preview', $competition) }}"
                        target="_blank">Preview</a>
                </form>
            </div>
        </div>


        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span>Export</span>
                <form action="{{ route('certificates.exportAll', $competition) }}" method="post" class="form-inline">
                    @csrf
                    <label class="mr-2">Batch size</label>
                    <input type="number" name="batch_size" class="form-control form-control-sm mr-2" value="40"
                        min="1" style="width: 90px;">
                    <button class="btn btn-success btn-sm">Export Whole Competition</button>
                </form>
            </div>
            <div class="card-body">
                <form action="{{ route('certificates.exportSelected', $competition) }}" method="post">
                    @csrf
                    <div class="table-responsive">
                        <table class="table table-striped table-sm">
                            <thead>
                                <tr>
                                    <th style="width:32px"><input type="checkbox" id="checkAll"></th>
                                    <th>Athlete</th>
                                    <th>Club</th>
                                    {{-- <th>Group</th> --}}
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($athletes as $a)
                                    <tr>
                                        <td><input type="checkbox" name="athlete_ids[]" value="{{ $a->id }}"></td>
                                        <td>{{ $a->first_name }} {{ $a->last_name }}</td>
                                        <td>{{ optional($a->club)->name }}</td>
                                        {{-- <td>{{ optional($a->pivot->group)->name ?? '-' }}</td> --}}
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <button class="btn btn-primary">Export Selected</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        document.getElementById('checkAll').addEventListener('change', function() {
            document.querySelectorAll('input[name="athlete_ids[]"]').forEach(cb => cb.checked = this.checked);
        });
    </script>
@endsection
