{{-- resources/views/certificates/pdf.blade.php --}}
@php
    $style = $template->style ?? [];
@endphp
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <style>
        @page {
            margin: 0;
        }

        body {
            margin: 0;
            font-family: DejaVu Sans, sans-serif;
        }

        .page {
            position: relative;
            width: 100%;
            height: 100vh;
        }

        .bg {
            position: absolute;
            inset: 0;
        }

        .center {
            position: absolute;
            left: 0;
            right: 0;
            text-align: center;
        }
    </style>
</head>

<body>
    @foreach ($athletes as $athlete)
        <div class="page">
            <img class="bg" src="{{ public_path( $template->background_path) }}"
                style="width: 100%; height: 100%; object-fit: cover;" />
            <div class="center" style="top: 15%;">
                <div style="font-size: {{ $style['title_font'] ?? 28 }}px; font-weight: bold;">{{ $template->title }}
                </div>
                @if (data_get($template->custom_fields, 'subtitle'))
                    <div style="font-size: {{ $style['subtitle_font'] ?? 18 }}px;">
                        {{ data_get($template->custom_fields, 'subtitle') }}</div>
                @endif
            </div>


            <div class="center" style="top: 45%;">
                <div style="font-size: {{ $style['name_font'] ?? 42 }}px; font-weight: 800;">{{ $athlete->first_name }}
                    {{ $athlete->last_name }}</div>
                <div style="font-size: 16px;">{{ $competition->title ?? 'Competition #' . $competition->id }}</div>
            </div>


            @if (data_get($template->custom_fields, 'footer'))
                <div class="center" style="bottom: 6%; font-size: 14px;">
                    {{ data_get($template->custom_fields, 'footer') }}</div>
            @endif
        </div>
        @if (!$loop->last)
            <div style="page-break-after: always;"></div>
        @endif
    @endforeach
</body>

</html>
