@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header bg-success text-white">
                <h4 class="mb-0">Edit Club</h4>
            </div>
            <div class="card-body">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <strong>There were some problems with your input:</strong>
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

             <form action="{{ route('clubs.update', $club->id) }}" method="POST">
    @csrf
    @method('PUT')

    {{-- NAME --}}
    <div class="form-group">
        <label for="name">Club Name</label>
        <input type="text"
               name="name"
               class="form-control @error('name') is-invalid @enderror"
               value="{{ old('name', $club->name) }}"
               required>
        @error('name')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    {{-- COUNTRY (now remembers old value) --}}
    <div class="form-group">
        <label for="country_id">Country</label>
        <select name="country_id"
                class="form-control @error('country_id') is-invalid @enderror"
                required>
            <option value="">-- Select Country --</option>
            @foreach ($countries as $country)
                <option value="{{ $country->id }}"
                    {{ old('country_id', $club->country_id) == $country->id ? 'selected' : '' }}>
                    {{ $country->name }}
                </option>
            @endforeach
        </select>
        @error('country_id')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <hr>

    {{-- LINKED CLUB ACCOUNT --}}
    <div class="form-group">
        <label for="email">Login Email</label>
        <input type="email"
               name="email"
               class="form-control @error('email') is-invalid @enderror"
               value="{{ old('email', $club->user?->email ?? '') }}"
               required>
        @error('email')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="form-group">
        <label for="password">New Password (leave blank to keep current)</label>
        <input type="password"
               name="password"
               class="form-control @error('password') is-invalid @enderror"
               placeholder="••••••••">
        @error('password')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="form-group">
        <label for="password_confirmation">Confirm New Password</label>
        <input type="password" name="password_confirmation" class="form-control" placeholder="••••••••">
    </div>

    {{-- DATES --}}
    <div class="form-row">
        <div class="form-group col-md-6">
            <label for="start_date">Start Date</label>
            <input type="datetime-local"
                   name="start_date"
                   class="form-control @error('start_date') is-invalid @enderror"
                   value="{{ old('start_date', $club->start_date) }}">
            @error('start_date')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group col-md-6">
            <label for="end_date">End Date</label>
            <input type="datetime-local"
                   name="end_date"
                   class="form-control @error('end_date') is-invalid @enderror"
                   value="{{ old('end_date', $club->end_date) }}">
            @error('end_date')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <button type="submit" class="btn btn-success mt-3">Update Club</button>
</form>

            </div>
        </div>
    </div>
@endsection
