@extends('layouts.app')
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/vendors.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
@endsection
@section('content')
    <section id="club-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Clubs</h4>
                        <a href="{{ route('clubs.create') }}" class="btn btn-primary">
                            <i class="bx bx-plus"></i> Add Club
                        </a>
                    </div>
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                       <table class="table zero-configuration">
    <thead>
        <tr>
            <th>*</th>
            <th>ID</th>
            <th>Name</th>
            <th>Owner</th>
            <th>Country</th>
            <th>Dates</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>

    <tbody>
        @foreach ($clubs as $club)
            @php
    $today = \Carbon\Carbon::today();
    $start = $club->start_date ? \Carbon\Carbon::parse($club->start_date) : null;
    $end   = $club->end_date ? \Carbon\Carbon::parse($club->end_date) : null;

    if (is_null($start) && is_null($end)) {
        // both missing → expired
        $status = 'Expired';
        $badge = 'danger';
    } elseif ($end && $end->lt($today)) {
        // end date passed
        $status = 'Expired';
        $badge = 'danger';
    } elseif ($start && $start->gt($today)) {
        // starts in future
        $status = 'Upcoming';
        $badge = 'info';
    } else {
        // valid and ongoing
        $status = 'Active';
        $badge = 'success';
    }
@endphp

            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $club->id }}</td>
                <td>{{ $club->name }}</td>
                <td>{{ $club->user?->email }}</td>
                <td>{{ $club->country?->name ?? '-' }}</td>

                {{-- Dates --}}
                <td>
                    <small>
                        {{ $club->start_date ?? '—' }}
                        —
                        {{ $club->end_date ?? 'Open' }}
                    </small>
                </td>

                {{-- Status --}}
                <td>
                    <span class="badge badge-{{ $badge }}">{{ $status }}</span>
                </td>

                <td>
                    <a href="{{ route('clubs.edit', $club->id) }}" class="btn btn-sm btn-warning">Edit</a>
                    <button type="button" class="btn btn-sm btn-danger btn-delete"
                            data-url="{{ route('clubs.destroy', $club->id) }}">
                        Delete
                    </button>
                </td>
            </tr>
        @endforeach
    </tbody>

    <tfoot>
        <tr>
            <th>*</th>
            <th>ID</th>
            <th>Name</th>
            <th>Owner</th>
            <th>Country</th>
            <th>Dates</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </tfoot>
</table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('js')
    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/ui/jquery.sticky.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
    <!-- END: Page Vendor JS-->



    <!-- BEGIN: Page JS-->
    <script src="{{ asset('app-assets/js/scripts/datatables/datatable.js') }}"></script>
    <!-- END: Page JS-->
@endsection
