@extends('layouts.app')

@section('css')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Assign Athlete to Competition</h4>
    </div>

    <div class="card-body">
        @if ($errors->any())
            <div class="alert alert-danger">
                <strong>Fix the following:</strong>
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('competitionathlete.store') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-2">
                    <label>Competition</label>
                    <select name="competition_id" class="form-control" required>
                        <option value="">Select Competition</option>
                        @foreach ($competitions as $competition)
                            <option value="{{ $competition->id }}">{{ $competition->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Athlete</label>
                    <select name="athlete_id" class="form-control select2-athlete" required>
                        <option value="">Select Athlete</option>
                        {{-- Populated by JS --}}
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Group</label>
                    <select name="group_id" class="form-control" required>
                        <option value="">Select Group</option>
                        {{-- Populated by JS --}}
                    </select>
                </div>
            </div>

            <div class="mt-2">
                <button class="btn btn-primary">Assign</button>
                <a href="{{ route('competitionathlete.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const competitionSelect = document.querySelector('select[name="competition_id"]');
    const groupSelect = document.querySelector('select[name="group_id"]');
    const athleteSelect = document.querySelector('select[name="athlete_id"]');

    // Initialize empty select2 on page load
    $('.select2-athlete').select2({
        placeholder: 'Select Athlete',
        allowClear: true,
        width: '100%'
    });

    competitionSelect.addEventListener('change', function () {
        const competitionId = this.value;

        groupSelect.innerHTML = '<option value="">Select Group</option>';
        $(athleteSelect).html('<option value="">Select Athlete</option>').trigger('change');

        if (competitionId) {
            // Fetch groups
            fetch(`/get-competition-groups/${competitionId}`)
                .then(response => response.json())
                .then(groups => {
                    groups.forEach(group => {
                        const option = document.createElement('option');
                        option.value = group.id;
                        option.textContent = group.name;
                        groupSelect.appendChild(option);
                    });
                })
                .catch(error => console.error('Error fetching groups:', error));

            // Fetch athletes
            fetch(`/get-competition-athletes/${competitionId}`)
                .then(response => response.json())
                .then(athletes => {
                    // Clear & re-init athlete select
                    $(athleteSelect).empty().append('<option value="">Select Athlete</option>');
                    athletes.forEach(athlete => {
                        const option = new Option(`${athlete.first_name} ${athlete.last_name}`, athlete.id, false, false);
                        $(athleteSelect).append(option);
                    });
                    $(athleteSelect).val(null).trigger('change');
                    $(athleteSelect).select2({
                        placeholder: 'Search Athlete',
                        allowClear: true,
                        width: '100%'
                    });
                })
                .catch(error => console.error('Error fetching athletes:', error));
        }
    });
});
</script>
@endsection
