@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Edit Athlete Assignment</h4>
    </div>

    <div class="card-body">
        @if ($errors->any())
            <div class="alert alert-danger">
                <strong>Please correct the following:</strong>
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('competitionathlete.update', $assignment->id) }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-2">
                    <label>Competition</label>
                    <select name="competition_id" class="form-control" required>
                        @foreach($competitions as $competition)
                            <option value="{{ $competition->id }}" {{ $assignment->competition_id == $competition->id ? 'selected' : '' }}>
                                {{ $competition->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Athlete</label>
                    <select name="athlete_id" class="form-control" required>
                        @foreach($athletes as $athlete)
                            <option value="{{ $athlete->id }}" {{ $assignment->athlete_id == $athlete->id ? 'selected' : '' }}>
                                {{ $athlete->first_name }} {{ $athlete->last_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Group</label>
                    <select name="group_id" class="form-control">
                        <option value="">(None)</option>
                        @foreach($groups as $group)
                            <option value="{{ $group->id }}" {{ $assignment->group_id == $group->id ? 'selected' : '' }}>
                                {{ $group->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="mt-2">
                <button class="btn btn-primary">Update</button>
                <a href="{{ route('competitionathlete.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
@section('js')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const competitionSelect = document.querySelector('select[name="competition_id"]');
    const groupSelect = document.querySelector('select[name="group_id"]');
    const currentGroupId = '{{ $assignment->group_id }}';

    function loadGroups(competitionId, preselectGroupId = null) {
        groupSelect.innerHTML = '<option value="">(None)</option>';

        if (competitionId) {
            fetch(`/get-competition-groups/${competitionId}`)
                .then(response => response.json())
                .then(groups => {
                    groups.forEach(group => {
                        const option = document.createElement('option');
                        option.value = group.id;
                        option.textContent = group.name;
                        if (preselectGroupId && group.id == preselectGroupId) {
                            option.selected = true;
                        }
                        groupSelect.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Error fetching groups:', error);
                });
        }
    }

    // On page load → load groups for preselected competition
    if (competitionSelect.value) {
        loadGroups(competitionSelect.value, currentGroupId);
    }

    // On change → reload groups
    competitionSelect.addEventListener('change', function () {
        loadGroups(this.value);
    });
});
</script>
@endsection
