@extends('layouts.app')
@section('css')
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
@endsection
@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="card-title">Competition Athlete Assignments</h4>

            <div class="btn-group">
                <a href="{{ route('competitionathlete.create') }}" class="btn btn-primary">
                    Assign Athlete
                </a>

                <button class="btn btn-success" data-toggle="collapse" data-target="#importForm">
                    Import Athletes
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <div id="importForm" class="collapse mt-2">
                    <div class="card card-body">
                        <a href="{{ asset('competition_athlete_import_template.xlsx') }}"
                            class="btn btn-sm btn-info mb-5 w-25">Download Sample File</a>
                        <form action="{{ route('competitionathlete.import.excel') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <label class="font-weight-bold">Upload Excel File (.xlsx)</label>
                            <input type="file" name="excel" class="form-control mb-2" required accept=".xlsx">

                            <button class="btn btn-success">Upload & Import</button>
                        </form>
                    </div>


                </div>

                @if (session('invalidRows'))
                    <div class="alert alert-warning mt-3">
                        <strong>Invalid Rows</strong>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Row</th>
                                    <th>Competition</th>
                                    <th>Athlete</th>
                                    <th>Group</th>
                                    <th>Error</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (session('invalidRows') as $row)
                                    <tr>
                                        <td>{{ $row['row'] }}</td>
                                        <td>{{ $row['competition_name'] }}</td>
                                        <td>{{ $row['athlete_name'] }}</td>
                                        <td>{{ $row['group_name'] }}</td>
                                        <td>{{ $row['error'] }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
                <table class="table table-bordered zero-configuration">
                    <thead>
                        <tr>
                            <th>*</th>
                            <th>Competition</th>
                            <th>Athlete</th>
                            <th>Group</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($assignments as $assign)
                            <tr>
                         <td>{{ $loop->iteration }}</td>
                                <td>{{ $assign->competition->name ?? '-' }}</td>
                                <td>{{ $assign->athlete->first_name }} {{ $assign->athlete->last_name }}</td>
                                <td>{{ $assign->group->name ?? '-' }}</td>
                                <td>
                                    <a href="{{ route('competitionathlete.edit', $assign->id) }}"
                                        class="btn btn-sm btn-warning">Edit</a>
                                    <form action="{{ route('competitionathlete.destroy', $assign->id) }}" method="POST"
                                        class="d-inline" onsubmit="return confirm('Delete this assignment?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>*</th>
                            <th>Competition</th>
                            <th>Athlete</th>
                            <th>Group</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
    <script src="{{ asset('app-assets/js/scripts/datatables/datatable.js') }}"></script>
@endsection
