@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Edit Competition</h4>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form action="{{ route('competitions.update', $competition->id) }}" method="POST">
                @csrf

                <div class="form-group">
                    <label for="name">Competition Name</label>
                    <input type="text" name="name" class="form-control" required
                        value="{{ old('name', $competition->name) }}">
                </div>

                <div class="form-group">
                    <label for="start_date">Start Date</label>
                    <input type="datetime-local" name="start_date" class="form-control"
                        value="{{ old('start_date', optional($competition->start_date)->format('Y-m-d H:i')) }}">

                </div>

                <div class="form-group">
                    <label for="end_date">End Date</label>
                    <input type="datetime-local" name="end_date" class="form-control"
                        value="{{ old('end_date', optional($competition->end_date)->format('Y-m-d H:i')) }}">

                </div>

                <div class="form-group">
                    <label for="location">Location</label>
                    <input type="text" name="location" class="form-control"
                        value="{{ old('location', $competition->location) }}">
                </div>

                <div class="form-group">
                    <label for="scoring_type">Scoring Type</label>
                    <select name="scoring_type" class="form-control" required>
                        <option value="FIG"
                            {{ old('scoring_type', $competition->scoring_type) == 'FIG' ? 'selected' : '' }}>FIG</option>
                        <option value="American"
                            {{ old('scoring_type', $competition->scoring_type) == 'American' ? 'selected' : '' }}>American
                        </option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="gender">Gender</label>
                    <select name="gender" class="form-control" required>
                        <option value="male" {{ old('gender', $competition->gender) == 'male' ? 'selected' : '' }}>Male
                        </option>
                        <option value="female" {{ old('gender', $competition->gender) == 'female' ? 'selected' : '' }}>
                            Female</option>
                    </select>
                </div>
                <div class="form-group form-check mt-3">
                    <input type="checkbox" name="enable_vault2" id="enable_vault2" class="form-check-input"
                        {{ old('enable_vault2', $competition->enable_vault2) ? 'checked' : '' }}>
                    <label class="form-check-label" for="enable_vault2">
                        Enable Vault 2
                    </label>
                    <small class="form-text text-muted">
                        When enabled, judges can score a second vault after Vault 1 is completed.
                    </small>
                </div>
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="{{ route('competitions.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
@endsection
