@extends('layouts.app')

@section('css')
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
@endsection

@section('content')
    <section id="competition-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Competitions</h4>
                      <div>
                          <a href="{{ route('competitions.create') }}" class="btn btn-primary">
                            <i class="bx bx-plus"></i> Add Competition
                        </a>
                        <a href="{{ route('competitions.team.create') }}" class="btn btn-primary">
                            <i class="bx bx-plus"></i> Add Team Competition
                        </a>
                      </div>
                    </div>
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table zero-configuration">
                                <thead>
                                    <tr>
                                        <th>*</th>
                                        <th>Name</th>
                                        <th>Gender</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Location</th>
                                        <th>Scoring Type</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($competitions as $competition)
                                        <tr>
                                            <td>{{ $loop->iteration ?? '-' }}</td>
                                            <td>
                                                <a href="{{ route('competitions.show', ['id' => $competition->id]) }}">
                                                    {{ $competition->name }}</a>
                                            </td>
                                            <td>{{ $competition->gender ? ucfirst($competition->gender) : '-' }}</td>

                                            <td>{{ $competition->start_date }}
                                            </td>
                                            <td>{{ $competition->end_date }}
                                            </td>
                                            <td>{{ $competition->location ?? '-' }}</td>
                                            <td>{{ $competition->scoring_type ?? '-' }}</td>
                                            <td>
                                                <a href="{{ route('competitions.edit', $competition->id) }}"
                                                    class="btn btn-sm btn-warning">Edit</a>
                                                <button type="button" class="btn btn-sm btn-danger btn-delete"
                                                    data-url="{{ route('competitions.destroy', $competition->id) }}">
                                                    Delete
                                                </button>
                                                <a href="{{ route('competitions.generateRotations', $competition->id) }}"
                                                    class="btn btn-sm btn-success generate-rotation-btn"
                                                    data-url="{{ route('competitions.generateRotations', $competition->id) }}">
                                                    Generate Rotations
                                                </a>
                                                <a href="{{ route('certificates.index', $competition->id) }}"
                                                    class="btn btn-outline-dark btn-sm">
                                                    Certificates
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>*</th>
                                        <th>Name</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Location</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('js')
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
    <script src="{{ asset('app-assets/js/scripts/datatables/datatable.js') }}"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const buttons = document.querySelectorAll('.generate-rotation-btn');

            buttons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const url = this.getAttribute('data-url');

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "This will auto-generate 4 rounds and apparatus rotations.",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, generate!',
                        cancelButtonText: 'Cancel',
                        reverseButtons: true
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = url;
                        }
                    });
                });
            });
        });
    </script>
@endsection
