@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header"><h4>Edit Group</h4></div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form action="{{ route('groups.update', $group->id) }}" method="POST">
                @csrf

                <div class="form-group">
                    <label for="competition_id">Competition</label>
                    <select name="competition_id" id="competition_id" class="form-control">
                        <option value="">Select Competition</option>
                        @foreach($competitions as $competition)
                            <option value="{{ $competition->id }}" {{ $group->competition_id == $competition->id ? 'selected' : '' }}>
                                {{ $competition->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="name">Group Name</label>
                    <input type="text" name="name" id="name" value="{{ $group->name }}" class="form-control" maxlength="10" required>
                </div>

                <button type="submit" class="btn btn-primary">Update</button>
                <a href="{{ route('groups.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection
