@extends('layouts.app')
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/vendors.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
@endsection
@section('content')
    <section id="group-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Groups</h4>

                        <div class="btn-group">
                            <a href="{{ route('groups.create') }}" class="btn btn-primary">
                                <i class="bx bx-plus"></i> Add Group
                            </a>

                            <button class="btn btn-success" data-toggle="collapse" data-target="#importExcel">
                                Import Excel
                            </button>
                        </div>
                    </div>

                    <div class="card-body card-dashboard">
                        <div id="importExcel" class="collapse mt-2">
                            <div class="card card-body">
                                <a href="{{ asset('group_import_template.xlsx') }}"
                                    class="btn btn-sm btn-info mb-5 w-25">Download Sample File</a>
                                <form action="{{ route('groups.import.excel') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                    <label class="font-weight-bold">Upload Excel File (.xlsx)</label>
                                    <input type="file" name="excel" class="form-control mb-2" required accept=".xlsx">

                                    <button class="btn btn-success">Upload & Import</button>
                                </form>
                            </div>


                        </div>

                        <div class="table-responsive">
                            @if (session('invalidRows') && count(session('invalidRows')))
                                <div class="alert alert-danger mt-3">
                                    <strong>Invalid Rows</strong>
                                    <table class="table table-bordered mt-2">
                                        <thead>
                                            <tr>
                                                <th>Row</th>
                                                <th>Group Name</th>
                                                <th>Competition Name</th>
                                                <th>Error</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (session('invalidRows') as $row)
                                                <tr>
                                                    <td>{{ $row['row'] }}</td>
                                                    <td>{{ $row['group_name'] }}</td>
                                                    <td>{{ $row['competition_name'] }}</td>
                                                    <td>{{ $row['error'] }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                            <table class="table zero-configuration">
                                <thead>
                                    <tr>
                                        <th>*</th>
                                        <th>Name</th>
                                        <th>Competition</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($groups as $group)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $group->name }}</td>
                                            <td>{{ $group->competition?->name ?? '-' }}</td>
                                            <td>
                                                <a href="{{ route('groups.edit', $group->id) }}"
                                                    class="btn btn-sm btn-warning">Edit</a>
                                                <button type="button" class="btn btn-sm btn-danger btn-delete"
                                                    data-url="{{ route('groups.destroy', $group->id) }}">
                                                    Delete
                                                </button>

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>*</th>
                                        <th>Name</th>
                                        <th>Competition</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('js')
    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/ui/jquery.sticky.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
    <!-- END: Page Vendor JS-->



    <!-- BEGIN: Page JS-->
    <script src="{{ asset('app-assets/js/scripts/datatables/datatable.js') }}"></script>
    <!-- END: Page JS-->
@endsection
