@extends('layouts.app')

@section('css')
<link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/pages/dashboard-analytics.css') }}">
@endsection

@section('content')
<!-- Dashboard Analytics Start -->
<section id="dashboard-analytics">
@php
$cardData = [
    ['Athletes', $totalAthletes, 'bx-user', 'primary', route('athletes.index')],
    ['Apparatus', $totalApparatus, 'bx-dumbbell', 'info', route('apparatus.index')],
    ['Judges', $totalJudges, 'bx-gavel', 'warning', route('judges.index')],
    ['Competitions', $totalCompetitions, 'bx-trophy', 'success', route('competitions.index')],
    ['Scores', $totalScores, 'bx-bar-chart-alt-2', 'danger', route('scores.index')],
    ['Completed Rounds', "$completedRounds / $totalRounds", 'bx-timer', 'secondary', route('competitions.index')],
];
@endphp

<div class="row">
    @foreach ($cardData as [$title, $value, $icon, $color, $link])
    <div class="col-md-4 mb-4">
        <a href="{{ $link }}" class="text-decoration-none">
            <div class="card border-{{ $color }} shadow h-100 hover-shadow">
                <div class="card-body d-flex align-items-center">
                    <div class="mr-3">
                        <i class="bx {{ $icon }} text-{{ $color }}" style="font-size:2rem;"></i>
                    </div>
                    <div>
                        <h6 class="text-uppercase text-muted mb-1">{{ $title }}</h6>
                        <h4 class="font-weight-bold mb-0 text-dark">{{ $value }}</h4>
                    </div>
                </div>
            </div>
        </a>
    </div>
    @endforeach
</div>


    <!-- Top 5 Athletes Chart -->
   <div class="row">
     <div class="col-md-6 card mt-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4>🏆 Top 5 Athletes</h4>
            <small class="text-muted">Updated live</small>
        </div>
        <div class="card-body">
            @if ($topAthletes->count())
                <canvas id="topAthletesChart" height="200"></canvas>
            @else
                <p class="text-center text-muted">No top athletes data available.</p>
            @endif
        </div>
    </div>

    <!-- Competition Athlete Scores Chart -->
    <div class="col-md-6 card mt-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4>📊 Competition Athlete Scores</h4>
            <small class="text-muted">Grouped by competition</small>
        </div>
        <div class="card-body">
            @if ($competitionScores->count())
                <canvas id="competitionScoresChart" height="300"></canvas>
            @else
                <p class="text-center text-muted">No competition score data available.</p>
            @endif
        </div>
    </div>
   </div>
</section>
<!-- Dashboard Analytics end -->
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Top Athletes Chart
    const topAthletes = @json($topAthletes);
    if (topAthletes.length > 0) {
        const labels = topAthletes.map(a => a.athlete.first_name + ' ' + a.athlete.last_name);
        const data = topAthletes.map(a => parseFloat(a.total));

        new Chart(document.getElementById('topAthletesChart').getContext('2d'), {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Total Score',
                    data: data,
                    backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b']
                }]
            },
            options: {
                responsive: true,
                plugins: { legend: { display: false } },
                scales: { y: { beginAtZero: true } }
            }
        });
    }

    // Competition Athlete Scores Chart
    const competitionScores = @json($competitionScores);
    if (competitionScores.length > 0) {
        const compLabels = competitionScores.map(c => c.name);
        const athleteNames = [...new Set(competitionScores.flatMap(c => c.athletes.map(a => a.athlete_name)))];

        const datasets = athleteNames.map((athlete, idx) => ({
            label: athlete,
            data: competitionScores.map(c => {
                const found = c.athletes.find(a => a.athlete_name === athlete);
                return found ? found.total : 0;
            }),
            backgroundColor: `hsl(${(idx * 50) % 360}, 70%, 50%)`
        }));

        new Chart(document.getElementById('competitionScoresChart').getContext('2d'), {
            type: 'bar',
            data: {
                labels: compLabels,
                datasets: datasets
            },
            options: {
                responsive: true,
                scales: {
                    x: { stacked: true },
                    y: { stacked: true, beginAtZero: true }
                },
                plugins: {
                    tooltip: { mode: 'index', intersect: false },
                    legend: { position: 'bottom' }
                }
            }
        });
    }
});
</script>
@endsection
