@extends('judge.master')
@section('judge_content')
    <div class="container" style="min-height: 100vh; display: flex; align-items: center; justify-content: center;">
    <div class="w-100">
        <h3 class="text-center mb-3">Select a Competition</h3>

        @if ($competitions->isEmpty())
            <p class="text-center">No competitions assigned to you.</p>
        @else
            <div class="row justify-content-center">
                @foreach ($competitions as $competition)
                    <div class="col-md-4 col-sm-6 mb-3">
                        <form action="{{ route('judge.setCompetition') }}" method="POST">
                            @csrf
                            <input type="hidden" name="competition_id" value="{{ $competition->id }}">
                            <button type="submit" class="card text-left w-100 btn t p-3 text-start"
                                style="text-align: left;">
                                <h5 class="mb-1">{{ $competition->name }}</h5>
                                <p class="mb-0 text-muted">
                                    {{ \Carbon\Carbon::parse($competition->start_date)->format('Y-m-d') }}
                                    to
                                    {{ \Carbon\Carbon::parse($competition->end_date)->format('Y-m-d') }}
                                    <br>
                                    <strong>Location:</strong> {{ $competition->location ?? 'N/A' }}
                                </p>
                            </button>
                        </form>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>

@endsection