<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<!-- BEGIN: Head-->
@include('layouts.head')
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern 2-columns navbar-sticky footer-static" data-open="click"
    data-menu="vertical-menu-modern" data-col="2-columns">

    <!-- BEGIN: Top Navbar with Logout -->
    <nav class="navbar navbar-light bg-white border-bottom px-3">
        <div class="d-flex align-items-center w-100 justify-content-between">
            <!-- Left: User name button -->
            <a href="#" class="btn btn-sm btn-outline-info d-flex align-items-center px-3 rounded-pill">
                <i class="fa fa-user-circle me-2"></i>
                <span>{{ Auth::user()->first_name }} {{ Auth::user()->last_name }}</span>
            </a>

            <!-- Center: Competition name if exists -->
            @if (session('competition_name'))
                <span class="fw-semibold text-primary">
                    🏆 {{ session('competition_name') }}
                </span>
            @endif

            <!-- Right: Logout button -->
            <a href="{{ route('logout') }}"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                class="btn btn-sm btn-outline-danger">
                <i class="fa fa-sign-out-alt me-1"></i> Logout
            </a>

            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
            </form>
        </div>
    </nav>

    <!-- END: Top Navbar -->

    <!-- BEGIN: Content-->
    <div class="">
        <div class="content-overlay"></div>
        @yield('judge_content')
    </div>
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Scripts-->
    @include('layouts.scripts')
    <!-- END: Scripts-->
</body>
<!-- END: Body-->

</html>
