@extends('judge.master')

@section('judge_content')
<div class="card">
    <div class="card-header">
        <h4>Round {{ $currentRound }} – Score Group {{ $rotation->group->name ?? $rotation->group_id }}</h4>
    </div>
    <div class="card-body">
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if (session('warning'))
            <div class="alert alert-warning">{{ session('warning') }}</div>
        @endif

        <form method="POST" action="{{ route('judge.submitRound') }}">
            @csrf
            <input type="hidden" name="round_number" value="{{ $currentRound }}">
            <input type="hidden" name="group_id" value="{{ $rotation->group_id }}">
            <input type="hidden" name="apparatus_id" value="{{ $rotation->apparatus_id }}">

            @foreach($athletes as $athlete)
                <div class="mb-3 border-bottom pb-2">
                    <strong>{{ $athlete->athlete->first_name }} {{ $athlete->athlete->last_name }}</strong>
                    <input type="hidden" name="athletes[{{ $athlete->athlete_id }}][athlete_id]" value="{{ $athlete->athlete_id }}">
                    
                    <div class="row mt-2">
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][e1_score]" placeholder="E1" required step="0.01" type="number">
                        </div>
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][e2_score]" placeholder="E2" required step="0.01" type="number">
                        </div>
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][e3_score]" placeholder="E3" step="0.01" type="number">
                        </div>
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][e4_score]" placeholder="E4" step="0.01" type="number">
                        </div>
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][d_score]" placeholder="D" required step="0.01" type="number">
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][bonus]" placeholder="Bonus" step="0.01" type="number">
                        </div>
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][cr_score]" placeholder="CR" step="0.01" type="number">
                        </div>
                        <div class="col-md-2">
                            <input class="form-control" name="athletes[{{ $athlete->athlete_id }}][nd_score]" placeholder="ND" step="0.01" type="number">
                        </div>
                    </div>
                </div>
            @endforeach

            <div class="text-end">
                <button class="btn btn-success mt-3">Submit Scores</button>
            </div>
        </form>
    </div>
</div>
@endsection
