{{-- resources/views/judge/vault2/index.blade.php --}}
@extends('layouts.app')
@section('title','Vault 2 – Today')

@section('content')
  <h4 class="mb-3">Vault 2 – Today’s Competitions</h4>
  @if($comps->isEmpty())
    <div class="alert alert-info">No Vault 2 competitions today.</div>
  @else
    <div class="list-group">
      @foreach($comps as $c)
        <a class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
           href="{{ route('judge.vault2.show', $c) }}">
          <span>
            <strong>{{ $c->title }}</strong>
            <small class="text-muted d-block">{{ $c->venue ?? '' }} — {{ $c->start_date->format('Y-m-d H:i') }}</small>
          </span>
          <span class="badge badge-{{ $c->vault2_status === 'complete' ? 'success':'secondary' }}">
            {{ ucfirst($c->vault2_status) }}
          </span>
        </a>
      @endforeach
    </div>
  @endif
@endsection
