{{-- resources/views/judge/vault2/scoring.blade.php --}}
@extends('layouts.app')
@section('title','Vault 2 – Scoring')

@section('content')
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">{{ $competition->title }} — Vault 2</h4>
    <span class="badge badge-{{ $competition->vault2_status === 'complete' ? 'success' : 'primary' }}">
      {{ ucfirst($competition->vault2_status) }}
    </span>
  </div>

  @if($top8->isEmpty())
    <div class="alert alert-info">No Vault 1 results. Vault 2 cannot start.</div>
  @else
    <div class="table-responsive">
      <table class="table table-striped table-hover">
        <thead class="thead-dark">
          <tr>
            <th>#</th><th>Athlete</th><th>Club</th><th>V1 Total</th><th>Vault 2</th>
          </tr>
        </thead>
        <tbody>
          @foreach($top8 as $i => $s)
            @php
              $already = isset($entered[$s->athlete_id]);
            @endphp
            <tr>
              <td>{{ $i+1 }}</td>
              <td>{{ $s->athlete->name }}</td>
              <td>{{ $s->athlete->club->name ?? '-' }}</td>
              <td><span class="badge badge-info">{{ number_format($s->final_total, 3) }}</span></td>
              <td>
                @if($already)
                  <span class="badge badge-success">Entered</span>
                @else
                  <form class="form-inline" method="POST"
                        action="{{ route('judge.vault2.store', [$competition, $s->athlete_id]) }}">
                    @csrf
                    <input name="d" type="number" step="0.1" min="0" max="10" class="form-control form-control-sm mr-1" placeholder="D" required>
                    <input name="e" type="number" step="0.1" min="0" max="10" class="form-control form-control-sm mr-1" placeholder="E" required>
                    <input name="nd" type="number" step="0.1" min="0" max="10" class="form-control form-control-sm mr-1" placeholder="ND">
                    <input name="penalty" type="number" step="0.1" min="0" max="10" class="form-control form-control-sm mr-1" placeholder="Pen">
                    <button class="btn btn-sm btn-primary">Save</button>
                  </form>
                @endif
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>

    {{-- Auto-refresh each 10s (no Pusher) --}}
    @push('scripts')
    <script>
      setTimeout(() => location.reload(), 10000);
    </script>
    @endpush
  @endif
@endsection
