@extends('auth.master')

@section('auth-content')
<div class="container py-5">

    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('login') }}" class="btn btn-outline-primary">
            <i class="bx bx-log-in"></i> Login
        </a>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">

            <div class="text-center mb-4">
                <h2 class="text-primary font-weight-bold">Select a Competition</h2>
                <p class="text-muted">Choose a competition below to view the live leaderboard.</p>
            </div>

            <div class="list-group shadow-sm">
                @forelse ($competitions as $competition)
                    <div class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <div class="mr-2">
                            <strong>{{ $competition->name }}</strong><br>
                            <small class="text-muted">
                                {{ $competition->location ?? 'No location' }} &bullet;
                                {{ \Carbon\Carbon::parse($competition->start_date)->format('F j, Y') }}
                            </small>
                        </div>

                        <div class="ml-auto d-flex">
                            <a href="{{ route('public.leaderboard.show', $competition->id) }}"
                               class="btn btn-sm btn-outline-secondary mr-2">
                                Overall
                            </a>

                            {{-- NEW: Show by Apparatus (opens modal) --}}
                            <button
                                class="btn btn-sm btn-primary"
                                data-toggle="modal"
                                data-target="#apparatusModal"
                                data-competition-id="{{ $competition->id }}"
                                data-competition-name="{{ $competition->name }}"
                            >
                                Show by Apparatus
                            </button>
                        </div>
                    </div>
                @empty
                    <div class="list-group-item text-center text-muted">
                        🚫 No competitions available at the moment.
                    </div>
                @endforelse
            </div>

        </div>
    </div>
</div>

{{-- Apparatus Modal --}}
<div class="modal fade" id="apparatusModal" tabindex="-1" role="dialog" aria-labelledby="apparatusModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content border-0 shadow">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="apparatusModalLabel">Select Apparatus</h5>
        <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
            <div class="text-muted">Competition: <span id="modalCompetitionName" class="font-weight-bold"></span></div>
        </div>

        <div class="list-group" id="apparatusList">
            {{-- Render apparatus options --}}
            @foreach ($apparatuses as $app)
              <label class="list-group-item d-flex align-items-center">
                <input type="radio" name="apparatus" class="mr-2" value="{{ $app->id }}">
                <div>
                  <div class="font-weight-bold">{{ $app->name }}</div>
                  <small class="text-muted">Only show scores for this apparatus</small>
                </div>
              </label>
            @endforeach
        </div>

        <div class="mt-3">
            <label class="mb-1 font-weight-bold">Display Duration</label>
            <div class="text-muted small mb-2">Configured by admins. Current default:
                <span class="badge badge-secondary">{{ $defaultCycleSeconds ?? 10 }}s</span>
            </div>
            <div class="text-muted small">The live page honors the competition's configured value.</div>
        </div>

      </div>
      <div class="modal-footer bg-light">
        <input type="hidden" id="modalCompetitionId">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button id="openLiveBtn" type="button" class="btn btn-success">Open Live Screen</button>
      </div>
    </div>
  </div>
</div>

{{-- Modal wiring --}}
<script>
document.addEventListener('DOMContentLoaded', function () {
  $('#apparatusModal').on('show.bs.modal', function (e) {
    const btn = $(e.relatedTarget);
    const compId = btn.data('competition-id');
    const compName = btn.data('competition-name');
    $('#modalCompetitionId').val(compId);
    $('#modalCompetitionName').text(compName);
    // default to ALL each open
    $('#apparatusList input[name="apparatus"]').prop('checked', false);
    $('#apparatusList input[name="apparatus"][value="all"]').prop('checked', true);
  });

  $('#openLiveBtn').on('click', function () {
    const compId = $('#modalCompetitionId').val();
    const appVal = $('#apparatusList input[name="apparatus"]:checked').val() || 'all';
    const url = @json(route('public.leaderboard.live', ['competitionId' => 'CID', 'apparatusId' => 'AID']));
    window.location.href = url.replace('CID', compId).replace('AID', appVal);
  });

  // Allow clicking the whole list item to select
  $('#apparatusList').on('click', '.list-group-item', function (e) {
    const radio = $(this).find('input[type="radio"]');
    radio.prop('checked', true);
  });
});
</script>
@endsection
