@extends('auth.master')

@section('auth-content')
    <style>
        .highlight-row td {
            background-color: #f8f9fa !important;
            font-weight: bold;
        }

        .fade-section {
            opacity: 0;
            transition: opacity 0.4s ease-in-out;
        }

        .fade-section.showing {
            opacity: 1;
        }

        .nav-pills .nav-link.active {
            background-color: #ffc107;
            color: #212529;
        }

        .page-indicator {
            font-size: 0.9em;
            color: #6c757d;
        }
    </style>

    <div class="container-fluid py-3">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2 id="competitionName" class="mb-0" style="font-weight:bold;font-size:2.5em;">
                <i class="bx bx-trophy"></i> {{ $activeCompetitions->first()->name ?? 'Competition' }}
            </h2>
        </div>

        {{-- AGE GROUP TABS --}}
        <ul class="nav nav-pills justify-content-center mb-4 flex-wrap" id="ageGroupTabs">
            @foreach ($ageCategories as $age)
                <li class="nav-item m-1">
                    <span class="nav-link" data-age="{{ $age->name }}" style="font-size:1.2em; cursor:pointer;">
                        {{ $age->name }}
                    </span>
                </li>
            @endforeach
        </ul>

        {{-- LEADERBOARD SECTIONS --}}
        <div class="leaderboard-sections">
            @foreach ($activeCompetitions as $competition)
                @foreach ($apparatuses as $apparatus)
                    @foreach ($ageCategories as $age)
                        @if ($competition->scoring_type === 'FIG')
                            @php
                                $athletes =
                                    $athleteRankings[$competition->name][$apparatus->name][$age->name] ?? collect();
                                $isEmpty = $athletes->isEmpty();
                                $sorted = $athletes
                                    ->sortByDesc(fn($a) => optional($a->scores->first())->final_score)
                                    ->values();
                                $chunks = $sorted->chunk(10);
                            @endphp

                            <div class="leaderboard-section {{ $isEmpty ? 'skip-section' : '' }} fade-section"
                                data-competition="{{ $competition->name }}" data-apparatus="{{ $apparatus->name }}"
                                data-age="{{ $age->name }}" data-level="none" style="display:none;">

                                <div class="text-center bg-success text-white py-2 mb-2"
                                    style="font-size:1.8em;font-weight:bold;">
                                    {{ $apparatus->name }} — {{ $age->name }}
                                </div>

                                <div class="table-responsive">
                                    <div class="text-right mb-1">
                                        <small class="page-indicator"></small>
                                    </div>

                                    <table class="table table-bordered table-hover text-center mb-0"
                                        style="font-size:1.3em;">
                                        <thead class="table-light">
                                            <tr>
                                                <th>#</th>
                                                <th>NF</th>
                                                <th>Athlete</th>
                                                <th>DScore</th>
                                                <th>Bonus</th>
                                                <th>CR Score</th>
                                                <th>ND Score</th>
                                                <th>Final</th>
                                            </tr>
                                        </thead>

                                        @foreach ($chunks as $pageIndex => $chunk)
                                            <tbody class="page-group" data-page="{{ $pageIndex }}"
                                                style="{{ $pageIndex === 0 ? '' : 'display:none;' }}">
                                                @foreach ($chunk as $i => $athlete)
                                                    @php $score=$athlete->scores->first(); @endphp
                                                    <tr
                                                        class="highlight-row {{ $i === 0 ? 'table-success' : ($i === 1 ? 'table-warning' : ($i === 2 ? 'table-info' : '')) }}">
                                                        <td>{{ $pageIndex * 10 + $i + 1 }}</td>
                                                        <td>{{ $athlete->country?->name ?? '—' }}</td>
                                                        <td>{{ $athlete->first_name }} {{ $athlete->last_name }}</td>
                                                        <td>{{ $score ? number_format($score->d_score, 2) : '-' }}</td>
                                                        <td>{{ $score ? number_format($score->bonus, 2) : '-' }}</td>
                                                        <td>{{ $score ? number_format($score->cr_score, 2) : '-' }}</td>
                                                        <td>{{ $score ? number_format($score->nd_score, 2) : '-' }}</td>
                                                        <td>
                                                            @if ($score)
                                                                {{ number_format($score->final_score, 2) }}
                                                                @if ($i === 0)
                                                                    🥇
                                                                @elseif($i === 1)
                                                                    🥈
                                                                @elseif($i === 2)
                                                                    🥉
                                                                @endif
                                                            @else
                                                                No score
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        @else
                            @foreach ($levels as $level)
                                @php
                                    $athletes =
                                        $athleteRankings[$competition->name][$apparatus->name][$age->name][
                                            $level->name
                                        ] ?? collect();
                                    $isEmpty = $athletes->isEmpty();
                                    $sorted = $athletes
                                        ->sortByDesc(fn($a) => optional($a->scores->first())->final_score)
                                        ->values();
                                    $chunks = $sorted->chunk(10);
                                @endphp

                                <div class="leaderboard-section {{ $isEmpty ? 'skip-section' : '' }} fade-section"
                                    data-competition="{{ $competition->name }}" data-apparatus="{{ $apparatus->name }}"
                                    data-age="{{ $age->name }}" data-level="{{ $level->name }}" style="display:none;">

                                    <div class="text-center bg-success text-white py-2 mb-2"
                                        style="font-size:1.8em;font-weight:bold;">
                                        Level {{ $level->name }} — {{ $apparatus->name }}
                                    </div>

                                    <div class="table-responsive">
                                        <div class="text-right mb-1">
                                            <h3 class="page-indicator"></h3>
                                        </div>
                                        <table class="table table-bordered table-hover text-center mb-0"
                                            style="font-size:1.3em;">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th>NF</th>
                                                    <th>Athlete</th>
                                                    <th>DScore</th>
                                                    <th>Bonus</th>
                                                    <th>CR Score</th>
                                                    <th>ND Score</th>
                                                    <th>Final</th>
                                                </tr>
                                            </thead>

                                            @foreach ($chunks as $pageIndex => $chunk)
                                                <tbody class="page-group" data-page="{{ $pageIndex }}"
                                                    style="{{ $pageIndex === 0 ? '' : 'display:none;' }}">
                                                    @foreach ($chunk as $i => $athlete)
                                                        @php $score=$athlete->scores->first(); @endphp
                                                        <tr
                                                            class="highlight-row {{ $i === 0 ? 'table-success' : ($i === 1 ? 'table-warning' : ($i === 2 ? 'table-info' : '')) }}">
                                                            <td>{{ $pageIndex * 10 + $i + 1 }}</td>
                                                            <td>{{ $athlete->country?->name ?? '—' }}</td>
                                                            <td>{{ $athlete->first_name }} {{ $athlete->last_name }}</td>
                                                            <td>{{ $score ? number_format($score->d_score, 2) : '-' }}</td>
                                                            <td>{{ $score ? number_format($score->bonus, 2) : '-' }}</td>
                                                            <td>{{ $score ? number_format($score->cr_score, 2) : '-' }}</td>
                                                            <td>{{ $score ? number_format($score->nd_score, 2) : '-' }}</td>
                                                            <td>
                                                                @if ($score)
                                                                    {{ number_format($score->final_score, 2) }}
                                                                    @if ($i === 0)
                                                                        🥇
                                                                    @elseif($i === 1)
                                                                        🥈
                                                                    @elseif($i === 2)
                                                                        🥉
                                                                    @endif
                                                                @else
                                                                    No score
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            @endforeach
                                        </table>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    @endforeach
                @endforeach
            @endforeach
        </div>
    </div>

    {{-- JS --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let competitions = @json($activeCompetitions->pluck('name'));
            let apparatuses = @json($apparatuses->pluck('name'));
            let ages = @json($ageCategories->pluck('name'));
            let levels = @json($levels->pluck('name'));
            let scoringTypes = @json($activeCompetitions->pluck('scoring_type', 'name'));

            let compIndex = 0,
                appIndex = 0,
                ageIndex = 0,
                levelIndex = 0,
                paused = false;

            function highlightAge(age) {
                document.querySelectorAll('#ageGroupTabs .nav-link').forEach(el => {
                    el.classList.toggle('active', el.dataset.age === age);
                });
            }

          function nextSection() {
  if (paused) return;
  let attempts = 0;
  const max = competitions.length * apparatuses.length * ages.length * levels.length;

  while (attempts < max) {
    let comp = competitions[compIndex],
        app = apparatuses[appIndex],
        age = ages[ageIndex],
        type = scoringTypes[comp],
        level = (type === 'FIG') ? 'none' : levels[levelIndex];

    let sel = `.leaderboard-section[data-competition="${comp}"][data-apparatus="${app}"][data-age="${age}"][data-level="${level}"]`;
    let sec = document.querySelector(sel);

    if (sec && !sec.classList.contains('skip-section')) {
      // Hide others and show this one
      document.querySelectorAll('.leaderboard-section').forEach(s => { 
        s.style.display = 'none'; 
        s.classList.remove('showing'); 
      });

      sec.style.display = 'block';
      sec.classList.add('showing');
      document.getElementById('competitionName').textContent = comp;
      highlightAge(age);
      rotatePages(sec);

      // ✅ Advance indexes for the NEXT call
      if (type === 'FIG') {
        ageIndex++;
        if (ageIndex >= ages.length) {
          ageIndex = 0;
          appIndex++;
          if (appIndex >= apparatuses.length) {
            appIndex = 0;
            compIndex++;
            if (compIndex >= competitions.length) compIndex = 0;
          }
        }
      } else {
        levelIndex++;
        if (levelIndex >= levels.length) {
          levelIndex = 0;
          ageIndex++;
          if (ageIndex >= ages.length) {
            ageIndex = 0;
            appIndex++;
            if (appIndex >= apparatuses.length) {
              appIndex = 0;
              compIndex++;
              if (compIndex >= competitions.length) compIndex = 0;
            }
          }
        }
      }
      break; // exit while after showing and advancing
    }

    // If not valid → skip ahead
    if (type === 'FIG') {
      ageIndex++;
      if (ageIndex >= ages.length) {
        ageIndex = 0; appIndex++;
        if (appIndex >= apparatuses.length) {
          appIndex = 0; compIndex++;
          if (compIndex >= competitions.length) compIndex = 0;
        }
      }
    } else {
      levelIndex++;
      if (levelIndex >= levels.length) {
        levelIndex = 0; ageIndex++;
        if (ageIndex >= ages.length) {
          ageIndex = 0; appIndex++;
          if (appIndex >= apparatuses.length) {
            appIndex = 0; compIndex++;
            if (compIndex >= competitions.length) compIndex = 0;
          }
        }
      }
    }
    attempts++;
  }
}

            function rotatePages(section) {
                let pages = section.querySelectorAll('.page-group');
                if (pages.length <= 1) return;
                let current = 0;
                const indicator = section.querySelector('.page-indicator');
                indicator.textContent = `Page 1 / ${pages.length}`;
                clearInterval(section.pageTimer);
                section.pageTimer = setInterval(() => {
                    if (!section.classList.contains('showing')) return;
                    pages[current].style.display = 'none';
                    current = (current + 1) % pages.length;
                    pages[current].style.display = '';
                    indicator.textContent = `Page ${current+1} / ${pages.length}`;
                }, 10000);
            }

            function startLoop() {
                setInterval(nextSection, {{ $cycleDuration * 1000 }});
            }

            window.addEventListener('keydown', e => {
                if (['INPUT', 'TEXTAREA'].includes(e.target.tagName)) return;
                const k = e.key.toLowerCase();
                if (k === 'p') paused = true;
                if (k === 'r') paused = false;
                if (k === 's') {
                    compIndex = appIndex = ageIndex = levelIndex = 0;
                    paused = false;
                    nextSection();
                }
            });

            nextSection();
            startLoop();
        });
    </script>
@endsection
